#ifndef __UDPHEADER_H_
#define __UDPHEADER_H_

#include "utils.h"

#pragma pack(push, 1)
struct _udp_header
{
  u_short srcport;
  u_short dstport;
  u_short length;
  u_short checksum;
};
#pragma pack(pop)

#define UDP_HEADER_SIZE sizeof(_udp_header)

class UDPHeader
{
public:
  UDPHeader(u_short _srcPort, u_char _dstPort, u_short _length);
  UDPHeader(const u_char *_data);
  void dump();
  void setMem(u_char *_data);
  const u_short srcPort() const;
  const u_short dstPort() const;
  const u_short length() const;
private:
  _udp_header data;
  void data2host(void);
  void data2network(void);

};
#endif
